<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddDependentTaskIdInTasksTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('tasks', function (Blueprint $table) {
            $table->integer('dependent_task_id')->unsigned()->nullable()->default(null)->after('recurring_task_id');
            $table->foreign('dependent_task_id')->references('id')->on('tasks')->onDelete('set null')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('tasks', function (Blueprint $table) {
            $table->dropForeign(['dependent_task_id']);
            $table->dropColumn(['dependent_task_id']);
        });
    }

}
